// mdNameCOMExample.cs
//
// Melissa Data mdName API for C# (via COM)
// Copyright 1993-2007 Melissa Data Corporation.

//********************************************************************************
//If you should have any comments, suggestions or improvements to these samples, 
//we welcome you to contact us at SampleCode@melissadata.com also please visit our 
//developers bulletin board at forum.melissadata.com.
//********************************************************************************

using System;
using System.IO;
using System.Text;

namespace mdNameCOMExample
{
	class mdNameCOMExample
	{
		static int Main()
		{
			int Record = 0;
			String FullName, ResultsString;
			StreamReader File;
            mdNAMEOBJECTLib.mdName Name = new mdNAMEOBJECTLib.mdName();

			// Change the following lines to reflect your installation location
			//   of the mdName API and the license string:
			// The Data Files Directory must contain the following files: mdName.dat and mdName.cfg.
			string dFILELOC=@"C:\Program Files\Melissa Data\DQT\Data";
			
        //********************** LICENSE STRINGS ***********************
        //*     To unlock the full functionality of Name Object,       *
        //*     	     Or to obtain a Demo License String            *
        //* please call a sales representative at 1-800-MELISSA ext. 3 *
        //*         (1-800-635-4772 x3) for a license string.          *
        //*    Replace the word DEMO with your valid license string    *
        //**************************************************************
		
            string dLICENSE = "DEMO";
            if (Name.SetLicenseString(dLICENSE)==0) {
				System.Console.WriteLine(string.Format(
					"Error setting License to \"{0}\"",dLICENSE));
                System.Console.WriteLine("Please contact a Melissa Data sales representative at 1-800-800-6245 x3 for a valid license string");
                System.Console.ReadKey();
				return 1;
			}

            // Point to Name Object data files and Initialize
			Name.PathToNameFiles = dFILELOC;
			if (Name.InitializeDataFiles()!= mdNAMEOBJECTLib.ProgramStatus.NoError) {
				System.Console.WriteLine(string.Format(
					"Error Initializing mdName: \"{0}\"",
					Name.GetInitializeErrorString()));
                System.Console.ReadKey();
				return 1;
			}

            // Get Initialization database properties
            System.Console.WriteLine("NAME OBJECT COM EXAMPLE\n");
            System.Console.WriteLine("          Build Number: " + Name.GetBuildNumber());
            System.Console.WriteLine("         Database Date: " + Name.GetDatabaseDate());
            System.Console.WriteLine("DatabaseExpirationDate: " + Name.GetDatabaseExpirationDate());
            System.Console.WriteLine(" LicenseExpirationDate: " + Name.GetLicenseExpirationDate());

			// Set a few processing options:
            Name.PrimaryNameHint = mdNAMEOBJECTLib.NameHints.Varying;
			Name.FirstNameSpellingCorrection = 1;
			Name.SalutationPrefix = "Dear";
			Name.SalutationSuffix = ":";
			Name.SalutationSlug = "Valued Customer";

			// Process the sample data file:
            try
            {
                File = new StreamReader("../../mdName.sdf");
            }
            catch (Exception)
            {
                Console.WriteLine("Cannot open demo file mdName.sdf");
                return 0;
            }
            
            // Get the Name to be parsed
			while ((FullName = File.ReadLine()) != null)
			{
				Name.ClearProperties();
				Name.FullName = FullName;
				Name.Parse();

                System.Console.Write(string.Format("\nRecord {0}" +
				  "  Full Name: {1}\n            Gender1: {2}\n"+
				  "            Prefix1: {3}\n        First Name1: {4}\n"+
				  "       Middle Name1: {5}\n         Last Name1: {6}\n"+
				  "            Suffix1: {7}\n            Gender2: {8}\n"+
				  "            Prefix2: {9}\n        First Name2: {10}\n"+
				  "       Middle Name2: {11}\n         Last Name2: {12}\n"+
				  "            Suffix2: {13}\n         Salutation: {14}\n",
					++Record,FullName,Name.Gender,Name.Prefix,Name.FirstName,
					Name.MiddleName,Name.LastName,Name.Suffix,Name.Gender2,
					Name.Prefix2,Name.FirstName2,Name.MiddleName2,
					Name.LastName2,Name.Suffix2,Name.Salutation));
                
                // Get the Result Codes
                ResultsString = Name.Results;
                System.Console.WriteLine("Results...\n");
                if (ResultsString.Contains("NS01"))  
                    System.Console.WriteLine("NS01: There were no Errors.");
                if (ResultsString.Contains("NS03"))
                    System.Console.WriteLine("NS03: The spelling of the FirstName field was corrected.");
                if (ResultsString.Contains("NS04"))
                    System.Console.WriteLine("NS04: The spelling of the FirstName2 field was corrected.");
                
                if (ResultsString.Contains("NS02"))
                {
                    System.Console.WriteLine("NS02: There was an Error...");
                    if (ResultsString.Contains("NE01"))
                        System.Console.WriteLine("NE01: Two names were detected but the FullName string was not in a recognized format.");
                    if (ResultsString.Contains("NE02"))
                        System.Console.WriteLine("NE02: Multiple first names  could not accurately genderize.");

                    if (ResultsString.Contains("NE03"))
                        System.Console.WriteLine("NE03: A vulgarity was detected in the name.");
                    if (ResultsString.Contains("NE04"))
                        System.Console.WriteLine("NE04: The name contained words found on the list of nuisance names [such as Mickey Mouse].");
                    if (ResultsString.Contains("NE05"))
                        System.Console.WriteLine("NE05: The name contained words normally found in a company name.");
                    if (ResultsString.Contains("NE06"))
                        System.Console.WriteLine("NE06: The named contained a non-alphabetic character.");
                 }
                 System.Console.WriteLine();

             }    // end while File.ReadLine()
            System.Console.ReadKey();
			return 0;
            
		}
	}
}